/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.IEasing;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class EasingRegistry {
    private static final Marker MARKER = MarkerManager.getMarker((String)"EasingRegistry");
    private static final EasingRegistry REGISTRY = new EasingRegistry();
    private final Int2ObjectMap<IEasing> mapById = new Int2ObjectOpenHashMap();
    private byte id;

    public static EasingRegistry getRegistry() {
        return REGISTRY;
    }

    public <E extends IEasing> E register(E easing, byte assignedId) {
        this.mapById.put((int)assignedId, easing);
        if (assignedId != this.id) {
            AnimationEngine.logger.warn(MARKER, "Got unexpected easing ID. Expected {}, got {}.", (Object)this.id, (Object)assignedId);
        }
        this.id = (byte)(this.id + 1);
        return easing;
    }

    public <E extends IEasing> E register(E easing) {
        easing.setEasingId(this.id);
        return this.register(easing, this.id);
    }

    public IEasing getEasing(byte id) {
        IEasing easing = (IEasing)this.mapById.get((int)id);
        return easing != null ? easing : AnimationUtils.DEFAULT_EASE_FUNC;
    }

    public Collection<IEasing> getRegisteredEasings() {
        return this.mapById.values();
    }

    private EasingRegistry() {
    }
}

